*** rt-E.do
*** v1.1
clear all
set more off
set type double
set matsize 1000

*** create rt vintages
insheet using CE16OV_2_Vintages_Starting_1961_02_09.txt, clear
gen int mdate = mofd(date(observation_date,"YMD"))
tsset mdate, m
order mdate
drop observation_date

** these releases took place the day preceding the "correct" month
rename ce16ov_19610531 ce16ov_19610601
rename ce16ov_19610829 ce16ov_19610901
rename ce16ov_19620131 ce16ov_19620201
rename ce16ov_19620531 ce16ov_19620601
rename ce16ov_19621031 ce16ov_19621101
rename ce16ov_19630131 ce16ov_19630201
rename ce16ov_19631031 ce16ov_19631101

** drop the day from the release date
unab rellist: ce16ov_*
local rdatelist: subinstr local rellist "ce16ov_" "", all
macro drop _rellist
foreach rdate of local rdatelist {
    local yr = string(int(`rdate'/10000),"%04.0f")
    local mon = string(int(`rdate'/100)-int(`rdate'/10000)*100,"%02.0f")
*    local rmdate = `yr'`mon'
    local rmdate = ym(`yr',`mon')
    rename ce16ov_`rdate' E_`rmdate'
}

compress
aorder
order mdate
save rt-E.dta, replace
